<?php
// Database Connection Test Script
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Database Connection Test</h2>";
echo "<hr>";

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'mathbariashop');

echo "<h3>1. Testing MySQL Connection...</h3>";
try {
    $conn = new PDO(
        "mysql:host=" . DB_HOST . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    echo "✅ <strong>MySQL Connection Successful!</strong><br>";
    echo "Host: " . DB_HOST . "<br>";
    echo "User: " . DB_USER . "<br>";
} catch(PDOException $e) {
    echo "❌ <strong>MySQL Connection Failed:</strong> " . $e->getMessage() . "<br>";
    exit;
}

echo "<hr>";
echo "<h3>2. Checking if database exists...</h3>";
try {
    $stmt = $conn->query("SHOW DATABASES LIKE '" . DB_NAME . "'");
    $dbExists = $stmt->fetch();
    if ($dbExists) {
        echo "✅ <strong>Database 'mathbariashop' exists!</strong><br>";
    } else {
        echo "❌ <strong>Database 'mathbariashop' does NOT exist!</strong><br>";
        echo "You need to run the schema.sql file to create the database.<br>";
    }
} catch(PDOException $e) {
    echo "❌ Error checking database: " . $e->getMessage() . "<br>";
}

echo "<hr>";
echo "<h3>3. Connecting to database and checking tables...</h3>";
try {
    $conn->exec("USE " . DB_NAME);
    echo "✅ <strong>Connected to database 'mathbariashop'</strong><br><br>";
    
    // Check if admins table exists
    $stmt = $conn->query("SHOW TABLES LIKE 'admins'");
    $tableExists = $stmt->fetch();
    if ($tableExists) {
        echo "✅ <strong>Table 'admins' exists!</strong><br>";
        
        // Check admin users
        $stmt = $conn->query("SELECT id, username, name, email, role FROM admins");
        $admins = $stmt->fetchAll();
        
        if (empty($admins)) {
            echo "⚠️ <strong>No admin users found in the table!</strong><br>";
            echo "You need to insert the default admin user.<br>";
        } else {
            echo "<br><strong>Admin Users:</strong><br>";
            echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
            echo "<tr><th>ID</th><th>Username</th><th>Name</th><th>Email</th><th>Role</th></tr>";
            foreach ($admins as $admin) {
                echo "<tr>";
                echo "<td>{$admin['id']}</td>";
                echo "<td>{$admin['username']}</td>";
                echo "<td>{$admin['name']}</td>";
                echo "<td>{$admin['email']}</td>";
                echo "<td>{$admin['role']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "❌ <strong>Table 'admins' does NOT exist!</strong><br>";
        echo "You need to run the schema.sql file to create the tables.<br>";
    }
    
    // List all tables
    echo "<br><strong>All Tables in Database:</strong><br>";
    $stmt = $conn->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    if (empty($tables)) {
        echo "⚠️ No tables found in the database.<br>";
    } else {
        echo "<ul>";
        foreach ($tables as $table) {
            echo "<li>{$table}</li>";
        }
        echo "</ul>";
    }
    
} catch(PDOException $e) {
    echo "❌ <strong>Error:</strong> " . $e->getMessage() . "<br>";
    if (strpos($e->getMessage(), "Unknown database") !== false) {
        echo "<br><strong>Solution:</strong> You need to create the database first by running:<br>";
        echo "<code>mysql -u root -e \"CREATE DATABASE mathbariashop CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;\"</code><br>";
        echo "Or import the database/schema.sql file.<br>";
    }
}

echo "<hr>";
echo "<h3>4. Testing password verification...</h3>";
try {
    $conn->exec("USE " . DB_NAME);
    $stmt = $conn->prepare("SELECT username, password FROM admins WHERE username = ?");
    $stmt->execute(['admin']);
    $admin = $stmt->fetch();
    
    if ($admin) {
        echo "✅ Admin user 'admin' found!<br>";
        $testPassword = 'admin123';
        if (password_verify($testPassword, $admin['password'])) {
            echo "✅ <strong>Password verification successful!</strong> Password 'admin123' is correct.<br>";
        } else {
            echo "❌ <strong>Password verification failed!</strong> The stored password hash doesn't match 'admin123'.<br>";
            echo "You may need to update the admin password in the database.<br>";
        }
    } else {
        echo "❌ Admin user 'admin' not found!<br>";
    }
} catch(PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

echo "<hr>";
echo "<h3>5. Testing getDBConnection() function...</h3>";
require_once '../api/config.php';
try {
    $testConn = getDBConnection();
    echo "✅ <strong>getDBConnection() function works!</strong><br>";
    $testConn = null;
} catch(Exception $e) {
    echo "❌ <strong>getDBConnection() failed:</strong> " . $e->getMessage() . "<br>";
}

echo "<hr>";
echo "<h3>Summary:</h3>";
echo "<p>If you see any ❌ errors above, please fix them before trying to login.</p>";
echo "<p><strong>Default Login Credentials:</strong><br>";
echo "Username: <code>admin</code><br>";
echo "Password: <code>admin123</code></p>";
echo "<p><a href='login.php'>Go to Login Page</a></p>";
?>

