<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method', null, 405);
}

$productId = isset($_POST['product_id']) ? (int)$_POST['product_id'] : 0;
$buyerId = isset($_POST['buyer_id']) ? (int)$_POST['buyer_id'] : 0;
$sellerId = isset($_POST['seller_id']) ? (int)$_POST['seller_id'] : 0;

if ($productId <= 0 || $buyerId <= 0 || $sellerId <= 0) {
    sendResponse(false, 'Invalid parameters', null, 400);
}

if ($buyerId === $sellerId) {
    sendResponse(false, 'Buyer and seller cannot be the same', null, 400);
}

try {
    $conn = getDBConnection();
    
    // Check if chat already exists
    $stmt = $conn->prepare(
        "SELECT id FROM chats 
         WHERE product_id = ? AND buyer_id = ? AND seller_id = ? 
         LIMIT 1"
    );
    $stmt->execute([$productId, $buyerId, $sellerId]);
    $existingChat = $stmt->fetch();
    
    if ($existingChat) {
        sendResponse(true, 'Chat found', [
            'chat_id' => $existingChat['id']
        ]);
    }
    
    // Create new chat
    $stmt = $conn->prepare(
        "INSERT INTO chats (product_id, buyer_id, seller_id, last_message, last_message_time) 
         VALUES (?, ?, ?, '', NOW())"
    );
    $stmt->execute([$productId, $buyerId, $sellerId]);
    $chatId = $conn->lastInsertId();
    
    sendResponse(true, 'Chat created successfully', [
        'chat_id' => $chatId
    ], 201);
    
} catch (PDOException $e) {
    error_log("Chat API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to create chat: ' . $e->getMessage(), null, 500);
}

?>
