<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method', null, 405);
}

$conn = getDBConnection();

// Ensure table exists (safety for existing installs)
try {
    $conn->exec("CREATE TABLE IF NOT EXISTS reported_products (
        id INT AUTO_INCREMENT PRIMARY KEY,
        product_id INT NOT NULL,
        reporter_id INT NULL,
        reason TEXT NOT NULL,
        status ENUM('pending', 'reviewed', 'dismissed') DEFAULT 'pending',
        admin_note TEXT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        reviewed_at TIMESTAMP NULL,
        FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
        FOREIGN KEY (reporter_id) REFERENCES users(id) ON DELETE SET NULL,
        INDEX idx_product (product_id),
        INDEX idx_reporter (reporter_id),
        INDEX idx_status (status)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
} catch (Exception $e) {
    // ignore if no permission
}

$productId = $_POST['product_id'] ?? null;
$reporterId = $_POST['reporter_id'] ?? null;
$reason = trim($_POST['reason'] ?? '');

if (!$productId) {
    sendResponse(false, 'Product ID is required', null, 400);
}

if ($reason === '') {
    sendResponse(false, 'Report reason is required', null, 400);
}

try {
    // Check product exists and is approved
    $stmt = $conn->prepare("SELECT id, status FROM products WHERE id = ?");
    $stmt->execute([$productId]);
    $product = $stmt->fetch();

    if (!$product) {
        sendResponse(false, 'Product not found', null, 404);
    }

    // Insert report
    $stmt = $conn->prepare("INSERT INTO reported_products (product_id, reporter_id, reason) VALUES (?, ?, ?)");
    $stmt->execute([
        $productId,
        $reporterId ?: null,
        $reason
    ]);

    sendResponse(true, 'আপনার রিপোর্ট গ্রহণ করা হয়েছে। এডমিন খুব দ্রুত পর্যালোচনা করবে।', null, 201);
} catch (PDOException $e) {
    sendResponse(false, 'Failed to submit report: ' . $e->getMessage(), null, 500);
}

?>


