<?php
/**
 * Test API endpoint to check if products are being returned correctly
 * Usage: http://yourdomain.com/api/test_api.php
 */
require_once 'config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$conn = getDBConnection();

try {
    // Test database connection
    $testQuery = $conn->query("SELECT COUNT(*) as total FROM products");
    $totalProducts = $testQuery->fetch()['total'];
    
    // Get sample products
    $stmt = $conn->query("SELECT p.*, 
                          GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images,
                          u.name as seller_name, u.is_blocked
                          FROM products p
                          LEFT JOIN product_images pi ON p.id = pi.product_id
                          LEFT JOIN users u ON p.seller_id = u.id
                          WHERE p.status = 'approved'
                          GROUP BY p.id
                          LIMIT 5");
    $products = $stmt->fetchAll();
    
    // Process images
    foreach ($products as &$product) {
        $product['images'] = $product['images'] ? explode(',', $product['images']) : [];
        $product['images'] = array_filter($product['images'], function($img) {
            return !empty(trim($img));
        });
        $product['images'] = array_map(function($img) {
            $img = trim($img);
            if (!empty($img) && strpos($img, 'http') !== 0) {
                return rtrim(UPLOAD_URL, '/') . '/' . ltrim($img, '/');
            }
            return $img;
        }, $product['images']);
        $product['images'] = array_values($product['images']);
        $product['price'] = (float)$product['price'];
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'API Test Successful',
        'config' => [
            'upload_url' => UPLOAD_URL,
            'upload_dir' => UPLOAD_DIR,
            'base_url' => BASE_URL,
        ],
        'stats' => [
            'total_products' => $totalProducts,
            'sample_count' => count($products),
        ],
        'sample_products' => $products
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'API Test Failed',
        'error' => $e->getMessage(),
        'config' => [
            'upload_url' => defined('UPLOAD_URL') ? UPLOAD_URL : 'NOT DEFINED',
            'upload_dir' => defined('UPLOAD_DIR') ? UPLOAD_DIR : 'NOT DEFINED',
        ]
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}


