<?php
/**
 * Test endpoint to check product images
 * Usage: http://ms.rumho.com/api/test_product_images.php
 */
require_once 'config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$conn = getDBConnection();

try {
    // Get a product with images
    $stmt = $conn->query(
        "SELECT p.id, p.title, 
                GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images
         FROM products p
         LEFT JOIN product_images pi ON p.id = pi.product_id
         WHERE p.status = 'approved'
         GROUP BY p.id
         LIMIT 5"
    );
    $products = $stmt->fetchAll();
    
    $result = [
        'upload_url' => UPLOAD_URL,
        'upload_dir' => UPLOAD_DIR,
        'products' => []
    ];
    
    foreach ($products as $product) {
        $images = $product['images'] ? explode(',', $product['images']) : [];
        $images = array_filter($images, function($img) {
            return !empty(trim($img));
        });
        
        $imageUrls = [];
        foreach ($images as $img) {
            $img = trim($img);
            if (!empty($img) && strpos($img, 'http') !== 0) {
                $fullUrl = rtrim(UPLOAD_URL, '/') . '/' . ltrim($img, '/');
                $imageUrls[] = [
                    'filename' => $img,
                    'full_url' => $fullUrl,
                    'file_exists' => file_exists(UPLOAD_DIR . $img),
                ];
            } else {
                $imageUrls[] = [
                    'filename' => $img,
                    'full_url' => $img,
                    'file_exists' => 'N/A',
                ];
            }
        }
        
        $result['products'][] = [
            'id' => $product['id'],
            'title' => $product['title'],
            'image_count' => count($imageUrls),
            'images' => $imageUrls,
        ];
    }
    
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'error' => $e->getMessage(),
        'upload_url' => defined('UPLOAD_URL') ? UPLOAD_URL : 'NOT DEFINED',
        'upload_dir' => defined('UPLOAD_DIR') ? UPLOAD_DIR : 'NOT DEFINED',
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

?>

