<?php
session_start();

if (isset($_SESSION['admin_id'])) {
    header('Location: index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once '../api/config.php';
    
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username && $password) {
        try {
            $conn = getDBConnection();
            
            // Check if admins table exists
            $tableCheck = $conn->query("SHOW TABLES LIKE 'admins'");
            if (!$tableCheck->fetch()) {
                $error = 'Database table not found. Please run the database setup script.';
            } else {
                $stmt = $conn->prepare("SELECT * FROM admins WHERE username = ?");
                $stmt->execute([$username]);
                $admin = $stmt->fetch();
                
                if ($admin && password_verify($password, $admin['password'])) {
                    $_SESSION['admin_id'] = $admin['id'];
                    $_SESSION['admin_name'] = $admin['name'];
                    $_SESSION['admin_role'] = $admin['role'];
                    header('Location: index.php');
                    exit;
                } else {
                    $error = 'Invalid username or password';
                }
            }
        } catch(PDOException $e) {
            $error = 'Database connection error: ' . $e->getMessage();
            // For debugging - remove in production
            if (strpos($e->getMessage(), 'Unknown database') !== false) {
                $error = 'Database "mathbariashop" not found. Please create the database first.';
            } elseif (strpos($e->getMessage(), 'Access denied') !== false) {
                $error = 'Database access denied. Please check your database credentials in api/config.php';
            }
        } catch(Exception $e) {
            $error = 'Error: ' . $e->getMessage();
        }
    } else {
        $error = 'Please enter username and password';
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Mathbaria Shop</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-card {
            max-width: 400px;
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="card shadow">
            <div class="card-body p-5">
                <h3 class="text-center mb-4">Admin Login</h3>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Username</label>
                        <input type="text" class="form-control" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" class="form-control" name="password" required>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">Login</button>
                </form>
                <p class="text-center mt-3 text-muted small">
                    Default: admin / admin123
                </p>
            </div>
        </div>
    </div>
</body>
</html>

