<?php
require_once '../config.php';

$userId = $_GET['user_id'] ?? null;

if (!$userId) {
    sendResponse(false, 'User ID is required', null, 400);
}

$userId = (int)$userId;

try {
    $conn = getDBConnection();
    
    // Get all chats where user is buyer or seller
    $stmt = $conn->prepare(
        "SELECT id FROM chats 
         WHERE buyer_id = ? OR seller_id = ?"
    );
    $stmt->execute([$userId, $userId]);
    $chats = $stmt->fetchAll();
    
    $unreadCounts = [];
    
    // Count unread messages for each chat
    foreach ($chats as $chat) {
        $chatId = $chat['id'];
        $stmt = $conn->prepare(
            "SELECT COUNT(*) as unread_count 
             FROM messages 
             WHERE chat_id = ? AND sender_id != ? AND seen = 0"
        );
        $stmt->execute([$chatId, $userId]);
        $result = $stmt->fetch();
        $unreadCount = (int)$result['unread_count'];
        
        if ($unreadCount > 0) {
            $unreadCounts[$chatId] = $unreadCount;
        }
    }
    
    sendResponse(true, 'Unread counts retrieved successfully', [
        'counts' => $unreadCounts
    ]);
    
} catch (PDOException $e) {
    error_log("Chat API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to retrieve unread counts: ' . $e->getMessage(), null, 500);
}

?>
