<?php
require_once '../config.php';

// Test chat API endpoints
header('Content-Type: application/json; charset=utf-8');

$testResults = [];

// Test 1: Check if get_or_create_chat.php exists and is accessible
$testResults['endpoints'] = [
    'get_or_create_chat.php' => file_exists(__DIR__ . '/get_or_create_chat.php'),
    'get_user_chats.php' => file_exists(__DIR__ . '/get_user_chats.php'),
    'get_messages.php' => file_exists(__DIR__ . '/get_messages.php'),
    'send_message.php' => file_exists(__DIR__ . '/send_message.php'),
    'mark_seen.php' => file_exists(__DIR__ . '/mark_seen.php'),
    'get_unread_counts.php' => file_exists(__DIR__ . '/get_unread_counts.php'),
];

// Test 2: Check database connection
try {
    $conn = getDBConnection();
    $testResults['database'] = [
        'connected' => true,
        'chats_table_exists' => false,
        'messages_table_exists' => false,
    ];
    
    // Check if chats table exists
    $stmt = $conn->query("SHOW TABLES LIKE 'chats'");
    $testResults['database']['chats_table_exists'] = $stmt->rowCount() > 0;
    
    // Check if messages table exists
    $stmt = $conn->query("SHOW TABLES LIKE 'messages'");
    $testResults['database']['messages_table_exists'] = $stmt->rowCount() > 0;
    
    // Get chat count
    if ($testResults['database']['chats_table_exists']) {
        $stmt = $conn->query("SELECT COUNT(*) as count FROM chats");
        $result = $stmt->fetch();
        $testResults['database']['total_chats'] = $result['count'] ?? 0;
    }
    
    // Get message count
    if ($testResults['database']['messages_table_exists']) {
        $stmt = $conn->query("SELECT COUNT(*) as count FROM messages");
        $result = $stmt->fetch();
        $testResults['database']['total_messages'] = $result['count'] ?? 0;
    }
    
} catch (Exception $e) {
    $testResults['database'] = [
        'connected' => false,
        'error' => $e->getMessage(),
    ];
}

// Test 3: Check API configuration
$testResults['config'] = [
    'base_url' => defined('BASE_URL') ? BASE_URL : 'Not defined',
    'upload_url' => defined('UPLOAD_URL') ? UPLOAD_URL : 'Not defined',
    'upload_dir' => defined('UPLOAD_DIR') ? UPLOAD_DIR : 'Not defined',
    'database_name' => defined('DB_NAME') ? DB_NAME : 'Not defined',
];

// Test 4: Check server variables
$testResults['server'] = [
    'protocol' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http',
    'host' => $_SERVER['HTTP_HOST'] ?? 'Not set',
    'script_name' => $_SERVER['SCRIPT_NAME'] ?? 'Not set',
    'request_method' => $_SERVER['REQUEST_METHOD'] ?? 'Not set',
];

// Test 5: Sample data check (if tables exist)
if (isset($testResults['database']['chats_table_exists']) && $testResults['database']['chats_table_exists']) {
    try {
        $stmt = $conn->query("SELECT * FROM chats ORDER BY id DESC LIMIT 3");
        $recentChats = $stmt->fetchAll();
        $testResults['sample_data'] = [
            'recent_chats' => $recentChats,
        ];
    } catch (Exception $e) {
        $testResults['sample_data'] = [
            'error' => $e->getMessage(),
        ];
    }
}

echo json_encode([
    'success' => true,
    'message' => 'Chat API test results',
    'data' => $testResults,
], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

?>
