<?php
require_once '../config.php';

$conn = getDBConnection();

// Get product ID from query parameter
$productId = $_GET['id'] ?? null;

if (!$productId) {
    sendResponse(false, 'Product ID is required', null, 400);
}

// Check if users.is_blocked column exists
$hasBlockedColumn = false;
try {
    $colCheck = $conn->query("SHOW COLUMNS FROM users LIKE 'is_blocked'");
    if ($colCheck && $colCheck->fetch()) {
        $hasBlockedColumn = true;
    }
} catch (Exception $e) {
    $hasBlockedColumn = false;
}

try {
    $query = "SELECT p.*, 
              GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images,
              u.name as seller_name,
              u.is_blocked
              FROM products p
              LEFT JOIN product_images pi ON p.id = pi.product_id
              LEFT JOIN users u ON p.seller_id = u.id
              WHERE p.id = :id
              GROUP BY p.id";
    
    $stmt = $conn->prepare($query);
    $stmt->execute([':id' => $productId]);
    $product = $stmt->fetch();
    
    if (!$product) {
        sendResponse(false, 'Product not found', null, 404);
    }

    if ($hasBlockedColumn && isset($product['is_blocked']) && (int)$product['is_blocked'] === 1) {
        sendResponse(false, 'Product not available', null, 404);
    }
    
    // Process images
    $product['images'] = $product['images'] ? explode(',', $product['images']) : [];
    // Filter out empty strings and build full URLs
    $product['images'] = array_filter($product['images'], function($img) {
        return !empty(trim($img));
    });
    $product['images'] = array_map(function($img) {
        $img = trim($img);
        // If image path doesn't start with http, prepend UPLOAD_URL
        if (!empty($img) && strpos($img, 'http') !== 0) {
            return rtrim(UPLOAD_URL, '/') . '/' . ltrim($img, '/');
        }
        return $img;
    }, $product['images']);
    $product['images'] = array_values($product['images']); // Re-index array
    $product['price'] = (float)$product['price'];
    
    // Ensure seller_id is present and valid
    if (!isset($product['seller_id']) || empty($product['seller_id'])) {
        error_log("WARNING: Product {$product['id']} has empty or missing seller_id!");
    }
    
    // Debug: Log product data
    error_log("Product retrieved: ID={$product['id']}, seller_id={$product['seller_id']}, seller_phone={$product['seller_phone']}");
    
    sendResponse(true, 'Product retrieved successfully', ['product' => $product]);
    
} catch(PDOException $e) {
    error_log("Product API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to retrieve product: ' . $e->getMessage(), null, 500);
}

?>

