<?php
session_start();

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../api/config.php';
$conn = getDBConnection();

// Get statistics
$stats = [
    'total_products' => $conn->query("SELECT COUNT(*) FROM products")->fetchColumn(),
    'pending_products' => $conn->query("SELECT COUNT(*) FROM products WHERE status = 'pending'")->fetchColumn(),
    'approved_products' => $conn->query("SELECT COUNT(*) FROM products WHERE status = 'approved'")->fetchColumn(),
    'total_users' => $conn->query("SELECT COUNT(*) FROM users")->fetchColumn(),
];

?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Mathbaria Shop</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
        }
        .sidebar a {
            color: #ecf0f1;
            text-decoration: none;
            padding: 15px;
            display: block;
        }
        .sidebar a:hover {
            background: #34495e;
        }
        .sidebar a.active {
            background: #3498db;
        }
        .stat-card {
            border-left: 4px solid #3498db;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar p-0">
                <div class="p-3">
                    <h4 class="text-white">Mathbaria Shop</h4>
                    <p class="text-white-50 small">Admin Panel</p>
                </div>
                <nav>
                    <a href="index.php" class="active"><i class="bi bi-house"></i> Dashboard</a>
                    <a href="products.php"><i class="bi bi-box"></i> Products</a>
                    <a href="pending.php"><i class="bi bi-clock-history"></i> Pending Approval</a>
                    <a href="users.php"><i class="bi bi-people"></i> Users</a>
                    <a href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
                </nav>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-10 p-4">
                <h2>Dashboard</h2>
                <hr>
                
                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card stat-card">
                            <div class="card-body">
                                <h5 class="card-title">Total Products</h5>
                                <h2><?php echo $stats['total_products']; ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card border-warning">
                            <div class="card-body">
                                <h5 class="card-title">Pending Approval</h5>
                                <h2 class="text-warning"><?php echo $stats['pending_products']; ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card border-success">
                            <div class="card-body">
                                <h5 class="card-title">Approved</h5>
                                <h2 class="text-success"><?php echo $stats['approved_products']; ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card">
                            <div class="card-body">
                                <h5 class="card-title">Total Users</h5>
                                <h2><?php echo $stats['total_users']; ?></h2>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Pending Products -->
                <div class="card">
                    <div class="card-header">
                        <h5>Recent Pending Products</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $stmt = $conn->prepare("SELECT p.*, u.name as seller_name 
                                                FROM products p 
                                                JOIN users u ON p.seller_id = u.id 
                                                WHERE p.status = 'pending' 
                                                ORDER BY p.created_at DESC 
                                                LIMIT 10");
                        $stmt->execute();
                        $pending = $stmt->fetchAll();
                        
                        if (empty($pending)) {
                            echo "<p class='text-muted'>No pending products</p>";
                        } else {
                            echo "<div class='table-responsive'><table class='table table-hover'>";
                            echo "<thead><tr><th>ID</th><th>Title</th><th>Price</th><th>Seller</th><th>Date</th><th>Action</th></tr></thead><tbody>";
                            foreach ($pending as $product) {
                                echo "<tr>";
                                echo "<td>{$product['id']}</td>";
                                echo "<td>{$product['title']}</td>";
                                echo "<td>৳{$product['price']}</td>";
                                echo "<td>{$product['seller_name']}</td>";
                                echo "<td>" . date('d M Y', strtotime($product['created_at'])) . "</td>";
                                echo "<td><a href='pending.php?id={$product['id']}' class='btn btn-sm btn-primary'>Review</a></td>";
                                echo "</tr>";
                            }
                            echo "</tbody></table></div>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>

