<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method', null, 405);
}

$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (empty($input['phone']) || empty($input['password']) || empty($input['name']) || empty($input['union'])) {
    sendResponse(false, 'All fields are required', null, 400);
}

$phone = preg_replace('/[^0-9]/', '', $input['phone']);
$password = $input['password'];
$name = trim($input['name']);
$union = trim($input['union']);

// Validate phone number (Bangladesh format: 01XXXXXXXXX)
if (!preg_match('/^01\d{9}$/', $phone)) {
    sendResponse(false, 'Invalid phone number. Please enter a valid Bangladesh mobile number (01XXXXXXXXX)', null, 400);
}

// Validate password
if (strlen($password) < 6) {
    sendResponse(false, 'Password must be at least 6 characters long', null, 400);
}

// Validate union (FINAL - Bengali names only)
$validUnions = ['মঠবাড়িয়া', 'আমড়াগাছিয়া', 'বেতমোর রাজপাড়া', 'বড়মাছুয়া', 'দাউদখালী', 
                'ধানীসাফা', 'গুলিশাখালী', 'মিরুখালী', 'শাপলেজা', 'টিকিকাটা', 'তুষখালী'];
if (!in_array($union, $validUnions)) {
    sendResponse(false, 'Invalid union selected', null, 400);
}

try {
    $conn = getDBConnection();
    
    // Check if phone already exists
    $stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
    $stmt->execute([$phone]);
    if ($stmt->fetch()) {
        sendResponse(false, 'Phone number already registered', null, 400);
    }
    
    // Hash password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    
    // Insert user
    $stmt = $conn->prepare("INSERT INTO users (phone, password, name, union_name) VALUES (?, ?, ?, ?)");
    $stmt->execute([$phone, $hashedPassword, $name, $union]);
    
    $userId = $conn->lastInsertId();
    
    // Get user data
    $stmt = $conn->prepare("SELECT id, phone, name, union_name, created_at FROM users WHERE id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    
    sendResponse(true, 'Registration successful', [
        'user' => $user
    ], 201);
    
} catch(PDOException $e) {
    sendResponse(false, 'Registration failed: ' . $e->getMessage(), null, 500);
}

?>

