<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'rumhocom_ms'); // Change if needed
define('DB_PASS', 'rumman.38'); // Change if needed
define('DB_NAME', 'rumhocom_ms');

// Base URL for API
define('BASE_URL', 'http://localhost/mathbariashop/api/');

// Image upload directory
define('UPLOAD_DIR', '../uploads/products/');
define('UPLOAD_URL', 'http://localhost/mathbariashop/uploads/products/');

// JWT Secret (change this to a random string)
define('JWT_SECRET', 'mathbaria_shop_secret_key_2024');

// Allowed image types
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/jpg', 'image/png', 'image/webp']);
define('MAX_IMAGE_SIZE', 5 * 1024 * 1024); // 5MB

// Timezone
date_default_timezone_set('Asia/Dhaka');

// Database Connection
function getDBConnection() {
    try {
        $conn = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return $conn;
    } catch(PDOException $e) {
        // Only send JSON response if this is an API request
        // Check if request is for API endpoint
        $isApiRequest = (strpos($_SERVER['REQUEST_URI'], '/api/') !== false || 
                        strpos($_SERVER['PHP_SELF'], '/api/') !== false);
        
        if ($isApiRequest) {
            http_response_code(500);
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode(['success' => false, 'message' => 'Database connection failed']);
            exit;
        } else {
            // For non-API requests, throw exception so it can be caught by the calling code
            throw $e;
        }
    }
}

// CORS Headers - Only set for API requests
$isApiRequest = (strpos($_SERVER['REQUEST_URI'], '/api/') !== false || 
                strpos($_SERVER['PHP_SELF'], '/api/') !== false);

if ($isApiRequest) {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
    header('Content-Type: application/json; charset=utf-8');
    
    // Handle preflight requests
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit;
    }
}

// Response helper function
function sendResponse($success, $message, $data = null, $statusCode = 200) {
    http_response_code($statusCode);
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'data' => $data
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// Create upload directory if not exists
$uploadDirPath = dirname(__DIR__) . '/' . str_replace('../', '', UPLOAD_DIR);
if (!file_exists($uploadDirPath)) {
    if (!mkdir($uploadDirPath, 0755, true)) {
        // Log error but don't break the application
        error_log("Failed to create upload directory: " . $uploadDirPath);
    }
}

// Also try with relative path (for backward compatibility)
if (!file_exists(UPLOAD_DIR)) {
    @mkdir(UPLOAD_DIR, 0755, true);
}

?>

