<?php
require_once '../config.php';

$conn = getDBConnection();

// Get query parameters
$union = $_GET['union'] ?? null;
$category = $_GET['category'] ?? null;
$status = $_GET['status'] ?? 'approved'; // Only show approved products to users

try {
    $query = "SELECT p.*, 
              GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images,
              u.name as seller_name
              FROM products p
              LEFT JOIN product_images pi ON p.id = pi.product_id
              LEFT JOIN users u ON p.seller_id = u.id
              WHERE p.status = :status";
    
    $params = [':status' => $status];
    
    if ($union) {
        $query .= " AND p.union_name = :union";
        $params[':union'] = $union;
    }
    
    if ($category) {
        $query .= " AND p.category = :category";
        $params[':category'] = $category;
    }
    
    $query .= " GROUP BY p.id ORDER BY p.created_at DESC";
    
    $stmt = $conn->prepare($query);
    $stmt->execute($params);
    $products = $stmt->fetchAll();
    
    // Process images
    foreach ($products as &$product) {
        $product['images'] = $product['images'] ? explode(',', $product['images']) : [];
        $product['images'] = array_map(function($img) {
            return UPLOAD_URL . $img;
        }, $product['images']);
        $product['price'] = (float)$product['price'];
    }
    
    sendResponse(true, 'Products retrieved successfully', ['products' => $products]);
    
} catch(PDOException $e) {
    sendResponse(false, 'Failed to retrieve products: ' . $e->getMessage(), null, 500);
}

?>

